const int tiltSwitchPin = 0; // Tilt switch on pin 0
const int led0 = 1;  // Top and bottom middle LEDs
const int led1 = 2;  // Top-left and bottom-right LEDs
const int led2 = 3;  // Top-right and bottom-left LEDs
const int led3 = 4;  // Center LED

void setup() {
  pinMode(led0, OUTPUT);
  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);
  pinMode(led3, OUTPUT);
  pinMode(tiltSwitchPin, INPUT_PULLUP);
  randomSeed(analogRead(A0));
}

void loop() {
    if (digitalRead(tiltSwitchPin) == LOW) {
      int roll = random(1, 7);
      displayDice(roll);
      delay(2000); // avoid multiple triggers
      digitalWrite(led0, LOW);
      digitalWrite(led1, LOW);
      digitalWrite(led2, LOW);
      digitalWrite(led3, LOW);
  }
}

void displayDice(int num) {

  switch (num) {
    case 1:
      digitalWrite(led0, HIGH);
      break;
    case 2:
      digitalWrite(led1, HIGH);
      break;
    case 3:
      digitalWrite(led0, HIGH);
      digitalWrite(led1, HIGH);
      break;
    case 4:
      digitalWrite(led1, HIGH);
      digitalWrite(led2, HIGH);
      break;
    case 5:
      digitalWrite(led0, HIGH);
      digitalWrite(led1, HIGH);
      digitalWrite(led2, HIGH);
      break;
    case 6:
      digitalWrite(led1, HIGH);
      digitalWrite(led2, HIGH);
      digitalWrite(led3, HIGH);
      break;
  }
}
